<?php

namespace Tests\Permissions;

use BookStack\Users\Models\User;
use Tests\TestCase;

class EntityOwnerChangeTest extends TestCase
{
    public function test_changing_page_owner()
    {
        $page = $this->entities->page();
        $user = User::query()->where('id', '!=', $page->owned_by)->first();

        $this->asAdmin()->put($page->getUrl('permissions'), ['owned_by' => $user->id]);
        $this->assertDatabaseHasEntityData('page', ['owned_by' => $user->id, 'id' => $page->id]);
    }

    public function test_changing_chapter_owner()
    {
        $chapter = $this->entities->chapter();
        $user = User::query()->where('id', '!=', $chapter->owned_by)->first();

        $this->asAdmin()->put($chapter->getUrl('permissions'), ['owned_by' => $user->id]);
        $this->assertDatabaseHasEntityData('chapter', ['owned_by' => $user->id, 'id' => $chapter->id]);
    }

    public function test_changing_book_owner()
    {
        $book = $this->entities->book();
        $user = User::query()->where('id', '!=', $book->owned_by)->first();

        $this->asAdmin()->put($book->getUrl('permissions'), ['owned_by' => $user->id]);
        $this->assertDatabaseHasEntityData('book', ['owned_by' => $user->id, 'id' => $book->id]);
    }

    public function test_changing_shelf_owner()
    {
        $shelf = $this->entities->shelf();
        $user = User::query()->where('id', '!=', $shelf->owned_by)->first();

        $this->asAdmin()->put($shelf->getUrl('permissions'), ['owned_by' => $user->id]);
        $this->assertDatabaseHasEntityData('bookshelf', ['owned_by' => $user->id, 'id' => $shelf->id]);
    }
}
