<?php
/**
 * Settings text strings
 * Contains all text strings used in the general settings sections of BookStack
 * including users and roles.
 */
return [

    // Common Messages
    'settings' => 'Cài đặt',
    'settings_save' => 'Lưu Cài đặt',
    'system_version' => 'Phiên bản Hệ thống',
    'categories' => 'Danh mục',

    // App Settings
    'app_customization' => 'Tuỳ biến',
    'app_features_security' => 'Chức năng & Bảo mật',
    'app_name' => 'Tên Ứng dụng',
    'app_name_desc' => 'Tên này được hiển thị trong header và trong bất kỳ email hệ thống được gửi.',
    'app_name_header' => 'Hiển thị tên trong header',
    'app_public_access' => 'Quyền truy cập công khai',
    'app_public_access_desc' => 'Bật tùy chọn này sẽ cho phép khách, người không cần đăng nhập, truy cập đến nội dung bản BookStack của bạn.',
    'app_public_access_desc_guest' => 'Quyền truy cập của khách có thể được điều khiển thông qua người dùng "Guest".',
    'app_public_access_toggle' => 'Cho phép truy cập công khai',
    'app_public_viewing' => 'Cho phép xem công khai?',
    'app_secure_images' => 'Bảo mật tốt hơn cho việc tải lên ảnh',
    'app_secure_images_toggle' => 'Bật bảo mật tốt hơn cho các ảnh được tải lên',
    'app_secure_images_desc' => 'Vì lý do hiệu năng, tất cả các ảnh đều được truy cập công khai. Tùy chọn này thêm một chuỗi ngẫu nhiên, khó đoán vào phần liên kết đến ảnh. Đảm bảo rằng tránh việc index thư mục để ngăn chặn việc truy cập đến ảnh một cách dễ dàng.',
    'app_default_editor' => 'Trình soạn thảo mặc định',
    'app_default_editor_desc' => 'Chọn trình soạn thảo nào sẽ được sử dụng theo mặc định khi chỉnh sửa trang mới. Điều này có thể bị ghi đè ở cấp độ trang nơi quyền cho phép.',
    'app_custom_html' => 'Tùy chọn nội dung Head HTML',
    'app_custom_html_desc' => 'Bất cứ nội dung nào được thêm vào đây sẽ được đưa vào phần cuối của khu vực <head> của mỗi trang. Tiện cho việc ghi đè style hoặc thêm mã phân tích dữ liệu.',
    'app_custom_html_disabled_notice' => 'Nội dung tùy biến HTML head bị tắt tại trang cài đặt này để đảm bảo mọi thay đổi làm hỏng hệ thống có để được khôi phục.',
    'app_logo' => 'Logo Ứng dụng',
    'app_logo_desc' => 'Điều này được sử dụng trong thanh tiêu đề của ứng dụng, trong số những khu vực khác. Hình ảnh này nên có chiều cao 86px. Những hình ảnh lớn sẽ được thu nhỏ lại.',
    'app_icon' => 'Biểu tượng ứng dụng',
    'app_icon_desc' => 'Biểu tượng này được sử dụng cho các tab trình duyệt và các biểu tượng phím tắt. Đây phải là hình ảnh PNG hình vuông 256px.',
    'app_homepage' => 'Trang chủ Ứng dụng',
    'app_homepage_desc' => 'Chọn hiển thị để hiện tại trang chủ thay cho hiển thị mặc định. Quyền cho trang được bỏ qua cho các trang được chọn.',
    'app_homepage_select' => 'Chọn một trang',
    'app_footer_links' => 'Liên kết chân trang',
    'app_footer_links_desc' => 'Thêm liên kết để hiển thị trong phần chân trang. Chúng sẽ được hiển thị ở dưới cùng của hầu hết các trang, bao gồm cả những trang không yêu cầu đăng nhập. Bạn có thể sử dụng nhãn "trans::<key>" để dùng bản dịch do hệ thống xác định. Ví dụ: Sử dụng "trans::common.privacy_policy" sẽ cung cấp văn bản được dịch là "Chính sách quyền riêng tư" và "trans::common.terms_of_service" sẽ cung cấp văn bản được dịch là "Điều khoản dịch vụ".',
    'app_footer_links_label' => 'Nhãn liên kết',
    'app_footer_links_url' => 'Địa chỉ liên kết',
    'app_footer_links_add' => 'Thêm liên kết chân trang',
    'app_disable_comments' => 'Tắt bình luận',
    'app_disable_comments_toggle' => 'Tắt bình luận',
    'app_disable_comments_desc' => 'Tắt các bình luận trên tất cả các trang của ứng dụng. <br> Các bình luận đã tồn tại sẽ không được hiển thị.',

    // Color settings
    'color_scheme' => 'Bảng màu ứng dụng',
    'color_scheme_desc' => 'Đặt các màu được sử dụng trong giao diện người dùng của ứng dụng. Màu sắc có thể được cấu hình riêng cho chế độ tối và sáng để phù hợp nhất với chủ đề và đảm bảo khả năng đọc.',
    'ui_colors_desc' => 'Đặt màu chính của ứng dụng và màu liên kết mặc định. Màu chính chủ yếu được sử dụng cho biểu ngữ đầu trang, nút và trang trí giao diện. Màu liên kết mặc định được sử dụng cho các liên kết và hành động dựa trên văn bản, cả trong nội dung đã viết và trong giao diện ứng dụng.',
    'app_color' => 'Màu cơ bản',
    'link_color' => 'Màu liên kết mặc định',
    'content_colors_desc' => 'Đặt màu cho tất cả các thành phần trong phân cấp tổ chức trang. Nên chọn màu có độ sáng tương tự với màu mặc định để có thể đọc được.',
    'bookshelf_color' => 'Màu Giá sách',
    'book_color' => 'Màu Sách',
    'chapter_color' => 'Màu Chương',
    'page_color' => 'Màu Trang',
    'page_draft_color' => 'Màu Trang Nháp',

    // Registration Settings
    'reg_settings' => 'Đăng ký',
    'reg_enable' => 'Bật Đăng ký',
    'reg_enable_toggle' => 'Bật đăng ký',
    'reg_enable_desc' => 'Khi đăng ký được bật, người dùng sẽ có thể tự đăng ký để trở thành người dùng của ứng dụng. Khi đăng kí, người dùng sẽ được cấp một quyền sử dụng mặc định.',
    'reg_default_role' => 'Quyền người dùng mặc định sau khi đăng kí',
    'reg_enable_external_warning' => 'Tùy chọn trên bị bỏ qua khi xác thực từ bên ngoài LDAP hoặc SAML được bật. Tài khoản người dùng chưa phải là thành viên sẽ được tự động tạo nếu xác thực với hệ thống bên ngoài thành công.',
    'reg_email_confirmation' => 'Xác nhận Email',
    'reg_email_confirmation_toggle' => 'Yêu cầu xác nhận email',
    'reg_confirm_email_desc' => 'Nếu giới hạn tên miền được sử dụng, xác nhận email là bắt buộc và tùy chọn này sẽ bị bỏ qua.',
    'reg_confirm_restrict_domain' => 'Giới hạn tên miền',
    'reg_confirm_restrict_domain_desc' => 'Điền dấu phẩy ngăn cách danh sách các tên miền email dành cho việc bạn muốn giới hạn đăng nhập. Người dùng sẽ nhận được email xác nhận địa chỉ của họ trước khi được phép tương tác với ứng dụng. <br> Lưu ý rằng người dùng có thể thay đổi địa chỉ email của họ sau khi đăng ký thành công.',
    'reg_confirm_restrict_domain_placeholder' => 'Không có giới hạn nào được thiết lập',

    // Sorting Settings
    'sorting' => 'Lists & Sorting',
    'sorting_book_default' => 'Default Book Sort Rule',
    'sorting_book_default_desc' => 'Chọn quy tắc sắp xếp mặc định để áp dụng cho sách mới. Điều này sẽ không ảnh hưởng đến các sách hiện có và có thể được ghi đè cho từng sách.',
    'sorting_rules' => 'Quy tắc sắp xếp',
    'sorting_rules_desc' => 'Đây là các thao tác sắp xếp được xác định trước có thể được áp dụng cho nội dung trong hệ thống.',
    'sort_rule_assigned_to_x_books' => 'Được gán cho :count sách|Được gán cho :count sách',
    'sort_rule_create' => 'Tạo quy tắc sắp xếp',
    'sort_rule_edit' => 'Chỉnh sửa quy tắc sắp xếp',
    'sort_rule_delete' => 'Xóa quy tắc sắp xếp',
    'sort_rule_delete_desc' => 'Xóa quy tắc sắp xếp này khỏi hệ thống. Sách sử dụng quy tắc này sẽ trở lại sắp xếp thủ công.',
    'sort_rule_delete_warn_books' => 'Quy tắc sắp xếp này hiện đang được sử dụng trên :count sách. Bạn có chắc chắn muốn xóa quy tắc này không?',
    'sort_rule_delete_warn_default' => 'Quy tắc sắp xếp này hiện đang được sử dụng làm mặc định cho sách. Bạn có chắc chắn muốn xóa quy tắc này không?',
    'sort_rule_details' => 'Chi tiết quy tắc sắp xếp',
    'sort_rule_details_desc' => 'Đặt tên cho quy tắc sắp xếp này, tên này sẽ xuất hiện trong danh sách khi người dùng chọn một sắp xếp.',
    'sort_rule_operations' => 'Thao tác sắp xếp',
    'sort_rule_operations_desc' => 'Cấu hình các hành động sắp xếp sẽ được thực hiện bằng cách di chuyển chúng từ danh sách các thao tác khả dụng. Khi sử dụng, các thao tác sẽ được áp dụng theo thứ tự, từ trên xuống dưới. Bất kỳ thay đổi nào được thực hiện ở đây sẽ được áp dụng cho tất cả các sách được gán khi lưu.',
    'sort_rule_available_operations' => 'Thao tác khả dụng',
    'sort_rule_available_operations_empty' => 'Không còn thao tác nào',
    'sort_rule_configured_operations' => 'Thao tác đã cấu hình',
    'sort_rule_configured_operations_empty' => 'Kéo/thêm thao tác từ danh sách "Thao tác khả dụng"',
    'sort_rule_op_asc' => '(Tăng dần)',
    'sort_rule_op_desc' => '(Giảm dần)',
    'sort_rule_op_name' => 'Tên - Theo bảng chữ cái',
    'sort_rule_op_name_numeric' => 'Tên - Theo số',
    'sort_rule_op_created_date' => 'Ngày tạo',
    'sort_rule_op_updated_date' => 'Ngày cập nhật',
    'sort_rule_op_chapters_first' => 'Chương trước',
    'sort_rule_op_chapters_last' => 'Chương sau',
    'sorting_page_limits' => 'Per-Page Display Limits',
    'sorting_page_limits_desc' => 'Set how many items to show per-page in various lists within the system. Typically a lower amount will be more performant, while a higher amount avoids the need to click through multiple pages. Using an even multiple of 3 (18, 24, 30, etc...) is recommended.',

    // Maintenance settings
    'maint' => 'Bảo trì',
    'maint_image_cleanup' => 'Dọn dẹp ảnh',
    'maint_image_cleanup_desc' => 'Quét nội dung trang và phiên bản để kiểm tra xem các ảnh và hình vẽ nào đang được sử dụng và ảnh nào dư thừa. Đảm bảo rằng bạn đã tạo bản sao lưu toàn bộ dữ liệu và ảnh trước khi chạy chức năng này.',
    'maint_delete_images_only_in_revisions' => 'Cũng xóa hình ảnh chỉ tồn tại trong các phiên bản trang cũ',
    'maint_image_cleanup_run' => 'Chạy Dọn dẹp',
    'maint_image_cleanup_warning' => 'Đã tìm thấy :count ảnh có thể không được sử dụng. Bạn muốn chắc rằng muốn xóa các ảnh này?',
    'maint_image_cleanup_success' => ':count ảnh có thể không được sử dụng đã được tìm thấy và xóa!',
    'maint_image_cleanup_nothing_found' => 'Không tìm thấy ảnh nào không được sử dụng, Không có gì để xóa!',
    'maint_send_test_email' => 'Gửi một email thử',
    'maint_send_test_email_desc' => 'Chức năng này gửi một email thử đến địa chỉ email bạn chỉ định trong hồ sơ của mình.',
    'maint_send_test_email_run' => 'Gửi email thử',
    'maint_send_test_email_success' => 'Email đã được gửi đến :address',
    'maint_send_test_email_mail_subject' => 'Thử Email',
    'maint_send_test_email_mail_greeting' => 'Chức năng gửi email có vẻ đã hoạt động!',
    'maint_send_test_email_mail_text' => 'Chúc mừng! Khi bạn nhận được email thông báo này, cài đặt email của bạn có vẻ đã được cấu hình đúng.',
    'maint_recycle_bin_desc' => 'Giá, sách, chương & trang đã xóa được gửi vào thùng rác để có thể khôi phục hoặc xóa vĩnh viễn. Các mục cũ hơn trong thùng rác có thể được tự động xóa sau một thời gian tùy thuộc vào cấu hình hệ thống.',
    'maint_recycle_bin_open' => 'Mở Thùng Rác',
    'maint_regen_references' => 'Tạo lại tài liệu tham khảo',
    'maint_regen_references_desc' => 'Hành động này sẽ tạo lại chỉ mục tham chiếu nhiều mục trong cơ sở dữ liệu. Thao tác này thường được xử lý tự động nhưng hành động này có thể hữu ích để lập chỉ mục nội dung cũ hoặc nội dung được thêm vào thông qua các phương pháp không chính thức.',
    'maint_regen_references_success' => 'Chỉ mục tham chiếu đã được tạo lại!',
    'maint_timeout_command_note' => 'Lưu ý: Hành động này có thể mất thời gian để chạy, điều này có thể dẫn đến các vấn đề về thời gian chờ trong một số môi trường web. Thay vào đó, hành động này được thực hiện bằng cách sử dụng một lệnh đầu cuối.',

    // Recycle Bin
    'recycle_bin' => 'Thùng Rác',
    'recycle_bin_desc' => 'Tại đây, bạn có thể khôi phục các mục đã bị xóa hoặc chọn xóa chúng vĩnh viễn khỏi hệ thống. Danh sách này không được lọc không giống như các danh sách hoạt động tương tự trong hệ thống áp dụng các bộ lọc quyền.',
    'recycle_bin_deleted_item' => 'Mục Đã Xóa',
    'recycle_bin_deleted_parent' => 'Thư mục cha',
    'recycle_bin_deleted_by' => 'Xóa Bởi',
    'recycle_bin_deleted_at' => 'Thời điểm Xóa',
    'recycle_bin_permanently_delete' => 'Xóa Vĩnh viễn',
    'recycle_bin_restore' => 'Khôi phục',
    'recycle_bin_contents_empty' => 'Thùng rác hiện đang trống',
    'recycle_bin_empty' => 'Dọn dẹp Thùng Rác',
    'recycle_bin_empty_confirm' => 'Thao tác này sẽ hủy vĩnh viễn tất cả các mục trong thùng rác bao gồm cả nội dung có trong mỗi mục. Bạn có chắc chắn muốn làm trống thùng rác?',
    'recycle_bin_destroy_confirm' => 'Hành động này sẽ xóa vĩnh viễn mục này khỏi hệ thống, cùng với bất kỳ phần tử con nào được liệt kê bên dưới và bạn sẽ không thể khôi phục nội dung này. Bạn có chắc chắn muốn xóa vĩnh viễn mục này không?',
    'recycle_bin_destroy_list' => 'Các mục sẽ bị hủy',
    'recycle_bin_restore_list' => 'Các mục sẽ được khôi phục',
    'recycle_bin_restore_confirm' => 'Hành động này sẽ khôi phục mục đã xóa, bao gồm mọi phần tử con, về vị trí ban đầu của chúng. Nếu vị trí ban đầu đã bị xóa và hiện đang nằm trong thùng rác, mục cha cũng sẽ cần được khôi phục.',
    'recycle_bin_restore_deleted_parent' => 'Mục cha của mục này cũng đã bị xóa. Chúng sẽ vẫn bị xóa cho đến khi mục cha đó cũng được khôi phục.',
    'recycle_bin_restore_parent' => 'Khôi phục mục cha',
    'recycle_bin_destroy_notification' => 'Đã xóa :count tổng số mục khỏi thùng rác.',
    'recycle_bin_restore_notification' => 'Đã khôi phục :count tổng số mục khỏi thùng rác.',

    // Audit Log
    'audit' => 'Nhật ký kiểm tra',
    'audit_desc' => 'Nhật ký kiểm tra này hiển thị danh sách các hoạt động được theo dõi trong hệ thống. Danh sách này không được lọc không giống như các danh sách hoạt động tương tự trong hệ thống nơi các bộ lọc quyền được áp dụng.',
    'audit_event_filter' => 'Bộ lọc sự kiện',
    'audit_event_filter_no_filter' => 'Không Lọc',
    'audit_deleted_item' => 'Mục Đã Xóa',
    'audit_deleted_item_name' => 'Tên: :name',
    'audit_table_user' => 'Người dùng',
    'audit_table_event' => 'Sự kiện',
    'audit_table_related' => 'Mục hoặc chi tiết liên quan',
    'audit_table_ip' => 'Địa chỉ IP',
    'audit_table_date' => 'Ngày hoạt động',
    'audit_date_from' => 'Ngày từ khoảng',
    'audit_date_to' => 'Ngày đến khoảng',

    // Role Settings
    'roles' => 'Quyền',
    'role_user_roles' => 'Quyền người dùng',
    'roles_index_desc' => 'Các quyền được sử dụng để nhóm người dùng và cung cấp quyền hệ thống cho các thành viên của họ. Khi một người dùng là thành viên của nhiều quyền, các đặc quyền được cấp sẽ chồng lên nhau và người dùng sẽ thừa hưởng tất cả các khả năng.',
    'roles_x_users_assigned' => ':count người dùng được gán|:count người dùng được gán',
    'roles_x_permissions_provided' => ':count quyền|:count quyền',
    'roles_assigned_users' => 'Người dùng được gán',
    'roles_permissions_provided' => 'Quyền được cung cấp',
    'role_create' => 'Tạo quyền mới',
    'role_delete' => 'Xóa quyền',
    'role_delete_confirm' => 'Chức năng này sẽ xóa quyền với tên \':roleName\'.',
    'role_delete_users_assigned' => 'Quyền này có :userCount người dùng được gán. Nếu bạn muốn di dời các người dùng từ quyền này hãy chọn một quyền mới bên dưới.',
    'role_delete_no_migration' => "Không di dời người dùng",
    'role_delete_sure' => 'Bạn có chắc rằng muốn xóa quyền này?',
    'role_edit' => 'Sửa quyền',
    'role_details' => 'Thông tin chi tiết Quyền',
    'role_name' => 'Tên quyền',
    'role_desc' => 'Thông tin vắn tắt của Quyền',
    'role_mfa_enforced' => 'Yêu cầu xác thực đa yếu tố',
    'role_external_auth_id' => 'Mã của xác thực ngoài',
    'role_system' => 'Quyền Hệ thống',
    'role_manage_users' => 'Quản lý người dùng',
    'role_manage_roles' => 'Quản lý quyền và chức năng quyền',
    'role_manage_entity_permissions' => 'Quản lý tất cả quyền của các sách, chương & trang',
    'role_manage_own_entity_permissions' => 'Quản lý quyền trên sách, chương & trang bạn tạo ra',
    'role_manage_page_templates' => 'Quản lý các mẫu trang',
    'role_access_api' => 'Truy cập đến API hệ thống',
    'role_manage_settings' => 'Quản lý cài đặt của ứng dụng',
    'role_export_content' => 'Xuất nội dung',
    'role_import_content' => 'Nhập nội dung',
    'role_editor_change' => 'Thay đổi trình soạn thảo trang',
    'role_notifications' => 'Nhận & quản lý thông báo',
    'role_permission_note_users_and_roles' => 'These permissions will technically also provide visibility & searching of users & roles in the system.',
    'role_asset' => 'Quyền tài sản (asset)',
    'roles_system_warning' => 'Cần lưu ý rằng việc truy cập vào bất kỳ ba quyền trên có thể cho phép người dùng thay đổi đặc quyền của chính họ hoặc đặc quyền của những người khác trong hệ thống. Chỉ gán các vai trò có các quyền này cho những người dùng đáng tin cậy.',
    'role_asset_desc' => 'Các quyền này điều khiển truy cập mặc định tới tài sản (asset) nằm trong hệ thống. Quyền tại Sách, Chương và Trang sẽ ghi đè các quyền này.',
    'role_asset_admins' => 'Quản trị viên được tự động cấp quyền truy cập đến toàn bộ nội dung, tuy nhiên các tùy chọn đó có thể hiện hoặc ẩn tùy chọn giao diện.',
    'role_asset_image_view_note' => 'Điều này liên quan đến khả năng hiển thị trong trình quản lý hình ảnh. Quyền truy cập thực tế vào các tệp hình ảnh đã tải lên sẽ phụ thuộc vào tùy chọn lưu trữ hình ảnh của hệ thống.',
    'role_asset_users_note' => 'These permissions will technically also provide visibility & searching of users in the system.',
    'role_all' => 'Tất cả',
    'role_own' => 'Sở hữu',
    'role_controlled_by_asset' => 'Kiểm soát các tài sản (asset) người dùng tải lên',
    'role_save' => 'Lưu Quyền',
    'role_users' => 'Người dùng được gán quyền này',
    'role_users_none' => 'Không có người dùng nào hiện được gán quyền này',

    // Users
    'users' => 'Người dùng',
    'users_index_desc' => 'Tạo và quản lý các tài khoản người dùng riêng lẻ trong hệ thống. Các tài khoản người dùng được sử dụng để đăng nhập và gán nội dung & hoạt động. Quyền truy cập chủ yếu dựa trên vai trò nhưng quyền sở hữu nội dung của người dùng, cùng với các yếu tố khác, cũng có thể ảnh hưởng đến quyền và truy cập.',
    'user_profile' => 'Hồ sơ người dùng',
    'users_add_new' => 'Thêm người dùng mới',
    'users_search' => 'Tìm kiếm người dùng',
    'users_latest_activity' => 'Hoạt động mới nhất',
    'users_details' => 'Chi tiết người dùng',
    'users_details_desc' => 'Hiển thị tên và địa chỉ email cho người dùng này. Địa chỉ email sẽ được sử dụng để đăng nhập vào ứng dụng.',
    'users_details_desc_no_email' => 'Đặt tên cho người dùng này để giúp người dùng khác nhận ra họ.',
    'users_role' => 'Quyền người dùng',
    'users_role_desc' => 'Chọn quyền mà người dùng sẽ được gán. Nếu người dùng được gán nhiều quyền, các quyền hạn sẽ ghi đè lên nhau và họ sẽ nhận được tất cả các quyền hạn từ quyền được gán.',
    'users_password' => 'Mật khẩu người dùng',
    'users_password_desc' => 'Đặt mật khẩu được sử dụng để đăng nhập vào ứng dụng. Mật khẩu phải dài ít nhất 8 ký tự.',
    'users_send_invite_text' => 'Bạn có thể chọn để gửi cho người dùng này một email mời, giúp họ có thể tự đặt mật khẩu cho chính họ. Nếu không bạn có thể đặt mật khẩu cho họ.',
    'users_send_invite_option' => 'Gửi email mời người dùng',
    'users_external_auth_id' => 'Mã của xác thực ngoài',
    'users_external_auth_id_desc' => 'Khi một hệ thống xác thực bên ngoài đang được sử dụng (chẳng hạn như SAML2, OIDC hoặc LDAP) đây là ID liên kết người dùng BookStack này với tài khoản hệ thống xác thực. Bạn có thể bỏ qua trường này nếu sử dụng xác thực dựa trên email mặc định.',
    'users_password_warning' => 'Chỉ điền vào phần bên dưới nếu bạn muốn thay đổi mật khẩu cho người dùng này.',
    'users_system_public' => 'Người dùng này đại diện cho bất kỳ khách nào thăm trang của bạn. Nó được tự động gán và không thể dùng để đăng nhập.',
    'users_delete' => 'Xóa Người dùng',
    'users_delete_named' => 'Xóa người dùng :userName',
    'users_delete_warning' => 'Chức năng này sẽ hoàn toàn xóa người dùng với tên \':userName\' khỏi hệ thống.',
    'users_delete_confirm' => 'Bạn có chắc muốn xóa người dùng này không?',
    'users_migrate_ownership' => 'Di chuyển quyền sở hữu',
    'users_migrate_ownership_desc' => 'Chọn một người dùng tại đây nếu bạn muốn một người dùng khác trở thành chủ sở hữu của tất cả các mục hiện thuộc sở hữu của người dùng này.',
    'users_none_selected' => 'Chưa chọn người dùng',
    'users_edit' => 'Sửa người dùng',
    'users_edit_profile' => 'Sửa Hồ sơ',
    'users_avatar' => 'Ảnh đại diện',
    'users_avatar_desc' => 'Chọn ảnh để đại diện cho người dùng này. Ảnh nên có kích cỡ hình vuông 256px.',
    'users_preferred_language' => 'Ngôn ngữ ưu tiên',
    'users_preferred_language_desc' => 'Tùy chọn này sẽ thay đổi ngôn ngữ sử dụng cho giao diện người dùng của ứng dụng. Nó sẽ không ảnh hưởng đến bất cứ nội dung nào người dùng tạo ra.',
    'users_social_accounts' => 'Tài khoản MXH',
    'users_social_accounts_desc' => 'Xem trạng thái của các tài khoản xã hội được kết nối cho người dùng này. Các tài khoản xã hội có thể được sử dụng ngoài hệ thống xác thực chính để truy cập hệ thống.',
    'users_social_accounts_info' => 'Bạn có thể kết nối đến các tài khoản khác để đăng nhập nhanh chóng và dễ dàng. Ngắt kết nối đến một tài khoản ở đây không thu hồi việc ủy quyền truy cập trước đó. Thu hồi truy cập của các tài khoản kết nối MXH từ trang cài đặt hồ sơ của bạn.',
    'users_social_connect' => 'Kết nối tài khoản',
    'users_social_disconnect' => 'Ngắt kết nối tài khoản',
    'users_social_status_connected' => 'Đã kết nối',
    'users_social_status_disconnected' => 'Đã ngắt kết nối',
    'users_social_connected' => 'Tài khoản :socialAccount đã được liên kết với hồ sơ của bạn thành công.',
    'users_social_disconnected' => 'Tài khoản :socialAccount đã được ngắt kết nối khỏi hồ sơ của bạn thành công.',
    'users_api_tokens' => 'Các Token API',
    'users_api_tokens_desc' => 'Tạo và quản lý các mã thông báo truy cập được sử dụng để xác thực với API REST của BookStack. Quyền cho API được quản lý thông qua người dùng mà mã thông báo thuộc về.',
    'users_api_tokens_none' => 'Không có Token API nào được tạo cho người dùng này',
    'users_api_tokens_create' => 'Tạo Token',
    'users_api_tokens_expires' => 'Hết hạn',
    'users_api_tokens_docs' => 'Tài liệu API',
    'users_mfa' => 'Xác thực đa yếu tố',
    'users_mfa_desc' => 'Thiết lập xác thực đa yếu tố như một lớp bảo mật bổ sung cho tài khoản người dùng của bạn.',
    'users_mfa_x_methods' => ':count phương thức đã cấu hình|:count phương thức đã cấu hình',
    'users_mfa_configure' => 'Cấu hình phương thức',

    // API Tokens
    'user_api_token_create' => 'Tạo Token API',
    'user_api_token_name' => 'Tên',
    'user_api_token_name_desc' => 'Đặt cho token của bạn một tên dễ đọc để nhắc nhở mục đích sử dụng của nó trong tương lai.',
    'user_api_token_expiry' => 'Ngày hết hạn',
    'user_api_token_expiry_desc' => 'Đặt một ngày hết hạn cho token này. Sau ngày này, các yêu cầu được tạo khi sử dụng token này sẽ không còn hoạt động. Để trống trường này sẽ đặt ngày hết hạn sau 100 năm tới.',
    'user_api_token_create_secret_message' => 'Ngay sau khi tạo token này một "Mã Token" & "Mật khẩu Token" sẽ được tạo và hiển thị. Mật khẩu sẽ chỉ được hiện một lần duy nhất nên hãy chắc rằng bạn sao lưu giá trị của nó ở nơi an toàn và bảo mật trước khi tiếp tục.',
    'user_api_token' => 'Token API',
    'user_api_token_id' => 'Mã Token',
    'user_api_token_id_desc' => 'Đây là hệ thống sinh ra định danh không thể chỉnh sửa cho token này, thứ mà sẽ cần phải cung cấp khi yêu cầu API.',
    'user_api_token_secret' => 'Mật khẩu Token',
    'user_api_token_secret_desc' => 'Đây là mật khẩu được hệ thống tạo ra cho token để phục vụ cho các yêu cầu API này. Nó sẽ chỉ được hiển thị một lần duy nhất nên hãy sao lưu nó vào nơi nào đó an toàn và bảo mật.',
    'user_api_token_created' => 'Token được tạo :timeAgo',
    'user_api_token_updated' => 'Token được cập nhật :timeAgo',
    'user_api_token_delete' => 'Xóa Token',
    'user_api_token_delete_warning' => 'Chức năng này sẽ hoàn toàn xóa token API với tên \':tokenName\' khỏi hệ thống.',
    'user_api_token_delete_confirm' => 'Bạn có chắc rằng muốn xóa token API này?',

    // Webhooks
    'webhooks' => 'Webhooks',
    'webhooks_index_desc' => 'Webhooks là một cách để gửi dữ liệu đến các URL bên ngoài khi một số hành động và sự kiện nhất định xảy ra trong hệ thống, cho phép tích hợp dựa trên sự kiện với các nền tảng bên ngoài như hệ thống nhắn tin hoặc thông báo.',
    'webhooks_x_trigger_events' => ':count sự kiện kích hoạt|:count sự kiện kích hoạt',
    'webhooks_create' => 'Tạo Webhook mới',
    'webhooks_none_created' => 'Chưa có webhooks nào được tạo.',
    'webhooks_edit' => 'Chỉnh sửa Webhook',
    'webhooks_save' => 'Lưu Webhook',
    'webhooks_details' => 'Chi tiết Webhook',
    'webhooks_details_desc' => 'Cung cấp một tên thân thiện với người dùng và một điểm cuối POST làm vị trí để dữ liệu webhook được gửi đến.',
    'webhooks_events' => 'Sự kiện Webhook',
    'webhooks_events_desc' => 'Chọn tất cả các sự kiện sẽ kích hoạt webhook này được gọi.',
    'webhooks_events_warning' => 'Hãy nhớ rằng các sự kiện này sẽ được kích hoạt cho tất cả các sự kiện đã chọn, ngay cả khi các quyền tùy chỉnh được áp dụng. Đảm bảo rằng việc sử dụng webhook này sẽ không làm lộ nội dung bí mật.',
    'webhooks_events_all' => 'Tất cả các sự kiện hệ thống',
    'webhooks_name' => 'Tên Webhook',
    'webhooks_timeout' => 'Thời gian chờ yêu cầu Webhook (Giây)',
    'webhooks_endpoint' => 'Điểm cuối Webhook',
    'webhooks_active' => 'Webhook hoạt động',
    'webhook_events_table_header' => 'Sự kiện',
    'webhooks_delete' => 'Xóa Webhook',
    'webhooks_delete_warning' => 'Điều này sẽ xóa hoàn toàn webhook này, với tên \':webhookName\', khỏi hệ thống.',
    'webhooks_delete_confirm' => 'Bạn có chắc chắn muốn xóa webhook này không?',
    'webhooks_format_example' => 'Ví dụ định dạng Webhook',
    'webhooks_format_example_desc' => 'Dữ liệu webhook được gửi dưới dạng yêu cầu POST đến điểm cuối đã cấu hình dưới dạng JSON theo định dạng bên dưới. Các thuộc tính "related_item" và "url" là tùy chọn và sẽ phụ thuộc vào loại sự kiện được kích hoạt.',
    'webhooks_status' => 'Trạng thái Webhook',
    'webhooks_last_called' => 'Lần cuối được gọi:',
    'webhooks_last_errored' => 'Lần cuối xảy ra lỗi:',
    'webhooks_last_error_message' => 'Nội dung lỗi gần nhất:',

    // Licensing
    'licenses' => 'Giấy phép',
    'licenses_desc' => 'Trang này trình bày chi tiết thông tin giấy phép cho BookStack ngoài các dự án & thư viện được sử dụng trong BookStack. Nhiều dự án được liệt kê có thể chỉ được sử dụng trong ngữ cảnh phát triển.',
    'licenses_bookstack' => 'Giấy phép BookStack',
    'licenses_php' => 'Giấy phép thư viện PHP',
    'licenses_js' => 'Giấy phép thư viện JavaScript',
    'licenses_other' => 'Các giấy phép khác',
    'license_details' => 'Chi tiết giấy phép',

    //! If editing translations files directly please ignore this in all
    //! languages apart from en. Content will be auto-copied from en.
    //!////////////////////////////////
    'language_select' => [
        'en' => 'English',
        'ar' => 'العربية',
        'bg' => 'Bǎlgarski',
        'bs' => 'Bosanski',
        'ca' => 'Català',
        'cs' => 'Česky',
        'cy' => 'Cymraeg',
        'da' => 'Đan Mạch',
        'de' => 'Deutsch (Sie)',
        'de_informal' => 'Deutsch (Du)',
        'el' => 'ελληνικά',
        'es' => 'Español',
        'es_AR' => 'Español Argentina',
        'et' => 'Eesti keel',
        'eu' => 'Euskara',
        'fa' => 'فارسی',
        'fi' => 'Suomi',
        'fr' => 'Français',
        'he' => 'עברית',
        'hr' => 'Hrvatski',
        'hu' => 'Magyar',
        'id' => 'Bahasa Indonesia',
        'it' => 'Italian',
        'ja' => '日本語',
        'ko' => '한국어',
        'lt' => 'Lietuvių Kalba',
        'lv' => 'Latviešu Valoda',
        'nb' => 'Norsk (Bokmål)',
        'ne' => 'नेपाली',
        'nn' => 'Nynorsk',
        'nl' => 'Nederlands',
        'pl' => 'Polski',
        'pt' => 'Português',
        'pt_BR' => 'Português do Brasil',
        'ro' => 'Română',
        'ru' => 'Русский',
        'sk' => 'Slovensky',
        'sl' => 'Slovenščina',
        'sv' => 'Svenska',
        'tr' => 'Türkçe',
        'uk' => 'Українська',
        'uz' => 'O‘zbekcha',
        'vi' => 'Tiếng Việt',
        'zh_CN' => '简体中文',
        'zh_TW' => '繁體中文',
    ],
    //!////////////////////////////////
];
