<?php
/**
 * Text used for 'Entities' (Document Structure Elements) such as
 * Books, Shelves, Chapters & Pages
 */
return [

    // Shared
    'recently_created' => 'أنشئت مؤخراً',
    'recently_created_pages' => 'صفحات أنشئت مؤخراً',
    'recently_updated_pages' => 'صفحات حُدثت مؤخراً',
    'recently_created_chapters' => 'فصول أنشئت مؤخراً',
    'recently_created_books' => 'كتب أنشئت مؤخراً',
    'recently_created_shelves' => 'أرفف أنشئت مؤخراً',
    'recently_update' => 'حُدثت مؤخراً',
    'recently_viewed' => 'عُرضت مؤخراً',
    'recent_activity' => 'نشاطات حديثة',
    'create_now' => 'أنشئ الآن',
    'revisions' => 'مراجعات',
    'meta_revision' => 'مراجعة #:revisionCount',
    'meta_created' => 'أنشئ :timeLength',
    'meta_created_name' => 'أنشئ :timeLength بواسطة :user',
    'meta_updated' => 'مُحدث :timeLength',
    'meta_updated_name' => 'مُحدث :timeLength بواسطة :user',
    'meta_owned_name' => 'مملوكة لـ:user',
    'meta_reference_count' => 'مشار إليه :count مرة|مشار إليه :count مرة',
    'entity_select' => 'اختيار الكيان',
    'entity_select_lack_permission' => 'ليس لديك الصلاحيات المطلوبة لتحديد هذا العنصر',
    'images' => 'صور',
    'my_recent_drafts' => 'مسوداتي الحديثة',
    'my_recently_viewed' => 'ما عرضته مؤخراً',
    'my_most_viewed_favourites' => 'مفضلاتي الأكثر مشاهدة',
    'my_favourites' => 'مفضلاتي',
    'no_pages_viewed' => 'لم تستعرض أي صفحات',
    'no_pages_recently_created' => 'لم تنشأ أي صفحات مؤخراً',
    'no_pages_recently_updated' => 'لم تُحدّث أي صفحات مؤخراً',
    'export' => 'تصدير',
    'export_html' => 'صفحة ويب',
    'export_pdf' => 'ملف PDF',
    'export_text' => 'ملف نص عادي',
    'export_md' => 'ملف ماركداون -Markdown-',
    'export_zip' => 'ملف مضغوط -ZIP-',
    'default_template' => 'قالب الصفحة الافتراضية',
    'default_template_explain' => 'قم بتعيين قالب صفحة سيتم استخدامه كمحتوى افتراضي لجميع الصفحات التي تم إنشاؤها ضمن هذا العنصر. ضع في اعتبارك أن هذا لن يتم استخدامه إلا إذا كان لدى منشئ الصفحة حق الوصول إلى صفحة القالب المختارة.',
    'default_template_select' => 'حدد صفحة القالب',
    'import' => 'استيراد',
    'import_validate' => 'التحقق من صحة الاستيراد',
    'import_desc' => 'استيراد الكتب والفصول والصفحات باستخدام تصدير مِلَفّ مضغوط ZIP محمول من نفس النظام أو نظام مختلف. حدد مِلَفّ ZIP للمتابعة. بعد تحميل المِلَفّ والتحقق من صحته، ستتمكن من إعداد وتأكيد الاستيراد في العرض التالي.',
    'import_zip_select' => 'حدد مِلَفّ مضغوط بصيغة ZIP للتحميل',
    'import_zip_validation_errors' => 'تم اكتشاف أخطاء في أثناء التحقق من صحة المِلَفّ المضغوط ZIP المقدم:',
    'import_pending' => 'الاستيرادات المعلقة',
    'import_pending_none' => 'لم يتم البَدْء في أي عملية استيراد.',
    'import_continue' => 'متابعة الاستيراد',
    'import_continue_desc' => 'راجع المحتوى الذي يجب استيراده من المِلَفّ المضغوط ZIP الذي تم تحميله. عندما يكون جاهزًا، تشتغل عملية الاستيراد لإضافة محتوياته إلى هذا النظام. سيتم إزالة مِلَفّ الاستيراد الذي تم تحميله تلقائيًا عند الاستيراد الناجح.',
    'import_details' => 'تفاصيل الاستيراد',
    'import_run' => 'تشغيل الاستيراد',
    'import_size' => 'حجم الاستيراد :size ',
    'import_uploaded_at' => 'تم تحميلة في  :relativeTime',
    'import_uploaded_by' => 'رُفِع بواسطة',
    'import_location' => 'موقع الاستيراد',
    'import_location_desc' => 'حدد موقعًا مستهدفًا للمحتوى المستورد. ستحتاج إلى الصلاحيات ذات الصلة لإنشاء المحتوى داخل الموقع الذي تختاره.',
    'import_delete_confirm' => 'متيقِّن من أنك تريد حذف الاستيراد؟',
    'import_delete_desc' => 'سيؤدي هذا إلى حذف مِلَفّ الاستيراد المضغوط ZIP، ولا يمكن التراجع عنه.',
    'import_errors' => 'أخطاء الاستيراد',
    'import_errors_desc' => 'حدثت الأخطاء التالية خلال محاولة الاستيراد:',
    'breadcrumb_siblings_for_page' => 'تصفح أشقاء هذه الصفحة',
    'breadcrumb_siblings_for_chapter' => 'تصفح أشقاء هذا الفصل',
    'breadcrumb_siblings_for_book' => 'تصفح أشقاء هذا الكتاب',
    'breadcrumb_siblings_for_bookshelf' => 'تصفح أشقاء هذا الرف',

    // Permissions and restrictions
    'permissions' => 'الأذونات',
    'permissions_desc' => 'تعيين الصلاحيات هنا لتجاوز الصلاحيات الافتراضية التي توفرها أدوار المستخدم.',
    'permissions_book_cascade' => 'سيتم نقل الصلاحيات التي تم تعيينها للكتب تلقائيًا إلى الفصول والصفحات الفرعية، ما لم تكن لديها صلاحيات خاصة بها محددة.',
    'permissions_chapter_cascade' => 'سيتم نقل الصلاحيات التي تم تعيينها على الفصول تلقائيًا إلى الصفحات الفرعية، ما لم تكن لديها صلاحيات خاصة بها محددة.',
    'permissions_save' => 'حفظ الأذونات',
    'permissions_owner' => 'المالك',
    'permissions_role_everyone_else' => 'الآخرين',
    'permissions_role_everyone_else_desc' => 'تعيين الصلاحيات لجميع الأدوار التي لم يتم تجاوزها على وجه التحديد.',
    'permissions_role_override' => 'تجاوز الصلاحيات للدور',
    'permissions_inherit_defaults' => 'وراثة الإعدادات الافتراضية',

    // Search
    'search_results' => 'نتائج البحث',
    'search_total_results_found' => 'عدد النتائج :count|مجموع النتائج :count',
    'search_clear' => 'مسح البحث',
    'search_no_pages' => 'لم يطابق بحثكم أي صفحة',
    'search_for_term' => 'ابحث عن :term',
    'search_more' => 'المزيد من النتائج',
    'search_advanced' => 'بحث مفصل',
    'search_terms' => 'البحث باستخدام المصطلحات',
    'search_content_type' => 'نوع المحتوى',
    'search_exact_matches' => 'نتائج مطابقة تماماً',
    'search_tags' => 'بحث الوسوم',
    'search_options' => 'الخيارات',
    'search_viewed_by_me' => 'استعرضت من قبلي',
    'search_not_viewed_by_me' => 'لم تستعرض من قبلي',
    'search_permissions_set' => 'حزمة الأذونات',
    'search_created_by_me' => 'أنشئت بواسطتي',
    'search_updated_by_me' => 'حُدثت بواسطتي',
    'search_owned_by_me' => 'مملوكة لي',
    'search_date_options' => 'خيارات التاريخ',
    'search_updated_before' => 'حدثت قبل',
    'search_updated_after' => 'حدثت بعد',
    'search_created_before' => 'أنشئت قبل',
    'search_created_after' => 'أنشئت بعد',
    'search_set_date' => 'تحديد التاريخ',
    'search_update' => 'تحديث البحث',

    // Shelves
    'shelf' => 'رف',
    'shelves' => 'الأرفف',
    'x_shelves' => ':count رف|:count أرفف',
    'shelves_empty' => 'لم ينشأ أي رف',
    'shelves_create' => 'إنشاء رف جديد',
    'shelves_popular' => 'أرفف رائجة',
    'shelves_new' => 'أرفف جديدة',
    'shelves_new_action' => 'رف جديد',
    'shelves_popular_empty' => 'ستظهر هنا الأرفف الأكثر رواجًا.',
    'shelves_new_empty' => 'ستظهر هنا الأرفف التي أنشئت مؤخرًا.',
    'shelves_save' => 'حفظ الرف',
    'shelves_books' => 'كتب على هذا الرف',
    'shelves_add_books' => 'إضافة كتب لهذا الرف',
    'shelves_drag_books' => 'اسحب الكتب الموجودة بالأسفل لإضافتها إلى هذا الرف',
    'shelves_empty_contents' => 'لا توجد كتب مخصصة لهذا الرف',
    'shelves_edit_and_assign' => 'تحرير الرف لإدراج كتب',
    'shelves_edit_named' => 'تعديل الرف :name',
    'shelves_edit' => 'تعديل الرف',
    'shelves_delete' => 'حذف الرف',
    'shelves_delete_named' => 'حذف الرف :name',
    'shelves_delete_explain' => "سيؤدي هذا إلى حذف الرف الذي يحمل الاسم ':name'. لن يتم حذف الكتب المضمنة بداخله.",
    'shelves_delete_confirmation' => 'هل أنت متأكد أنك تريد حذف هذا الرف؟',
    'shelves_permissions' => 'صلاحيات الرف',
    'shelves_permissions_updated' => 'تم تحديث صلاحيات الرف',
    'shelves_permissions_active' => 'صلاحيات الرف نشطة',
    'shelves_permissions_cascade_warning' => 'لا يتم نقل الصلاحيات الموجودة على الأرفف تلقائيًا إلى الكتب الموجودة في كل رف. وذلك لأن الكتاب يمكن أن يوجد على أرفف متعددة. ومع ذلك، يمكن نسخ الصلاحيات إلى الكتب الفرعية باستخدام الخِيار الموجود أدناه.',
    'shelves_permissions_create' => 'تُستخدم صلاحيات إنشاء الرفوف فقط لنسخ الصلاحيات إلى الكتب الفرعية باستخدام الإجراء أدناه. ولا تتحكم في القدرة على إنشاء الكتب.',
    'shelves_copy_permissions_to_books' => 'نسخ أذونات الوصول إلى الكتب',
    'shelves_copy_permissions' => 'نسخ الأذونات',
    'shelves_copy_permissions_explain' => 'سيؤدي هذا إلى تطبيق إعدادات الصلاحيات الحالية لهذا الرف على جميع الكتب الموجودة بداخله. قبل التنشيط، تأكد من حفظ أي تغييرات على صلاحيات هذا الرف.',
    'shelves_copy_permission_success' => 'تم نسخ صلاحيات الرف إلى :count كتاب/كتب',

    // Books
    'book' => 'كتاب',
    'books' => 'الكتب',
    'x_books' => ':count كتاب|:count كتب',
    'books_empty' => 'لم يتم إنشاء أي كتب',
    'books_popular' => 'كتب رائجة',
    'books_recent' => 'كتب حديثة',
    'books_new' => 'كتب جديدة',
    'books_new_action' => 'كتاب جديد',
    'books_popular_empty' => 'الكتب الأكثر رواجاً ستظهر هنا.',
    'books_new_empty' => 'الكتب المنشأة مؤخراً ستظهر هنا.',
    'books_create' => 'إنشاء كتاب جديد',
    'books_delete' => 'حذف الكتاب',
    'books_delete_named' => 'حذف كتاب :bookName',
    'books_delete_explain' => 'سيتم حذف كتاب \':bookName\'، وأيضا حذف جميع الفصول والصفحات.',
    'books_delete_confirmation' => 'تأكيد حذف الكتاب؟',
    'books_edit' => 'تعديل الكتاب',
    'books_edit_named' => 'تعديل كتاب :bookName',
    'books_form_book_name' => 'اسم الكتاب',
    'books_save' => 'حفظ الكتاب',
    'books_permissions' => 'أذونات الكتاب',
    'books_permissions_updated' => 'تم تحديث أذونات الكتاب',
    'books_empty_contents' => 'لم يتم إنشاء أي صفحات أو فصول لهذا الكتاب.',
    'books_empty_create_page' => 'إنشاء صفحة جديدة',
    'books_empty_sort_current_book' => 'فرز الكتاب الحالي',
    'books_empty_add_chapter' => 'إضافة فصل',
    'books_permissions_active' => 'أذونات الكتاب مفعلة',
    'books_search_this' => 'البحث في هذا الكتاب',
    'books_navigation' => 'تصفح الكتاب',
    'books_sort' => 'فرز محتويات الكتاب',
    'books_sort_desc' => 'نقل الفصول والصفحات داخل الكتاب لإعادة تنظيم محتوياته. يمكن إضافة كتب أخرى مما يسمح بنقل الفصول والصفحات بسهولة بين الكتب. اختياريًا، يمكن تعيين قاعدة فرز تلقائي لفرز محتويات هذا الكتاب تلقائيًا عند حدوث تغييرات.',
    'books_sort_auto_sort' => 'خِيار الفرز التلقائي',
    'books_sort_auto_sort_active' => 'الفرز التلقائي الشَغَّال: :sortName',
    'books_sort_named' => 'فرز كتاب :bookName',
    'books_sort_name' => 'ترتيب حسب الإسم',
    'books_sort_created' => 'ترتيب حسب تاريخ الإنشاء',
    'books_sort_updated' => 'فرز حسب تاريخ التحديث',
    'books_sort_chapters_first' => 'الفصول الأولى',
    'books_sort_chapters_last' => 'الفصول الأخيرة',
    'books_sort_show_other' => 'عرض كتب أخرى',
    'books_sort_save' => 'حفظ الترتيب الجديد',
    'books_sort_show_other_desc' => 'أضف كتبًا أخرى هنا لتضمينها في عملية الفرز، والسماح بإعادة تنظيم الكتب بسهولة.',
    'books_sort_move_up' => 'حرك للأعلى',
    'books_sort_move_down' => 'حرك للأسفل',
    'books_sort_move_prev_book' => 'نقل للكتاب السابق',
    'books_sort_move_next_book' => 'نقل للكتاب التالي',
    'books_sort_move_prev_chapter' => 'نقل إلى الفصل السابق',
    'books_sort_move_next_chapter' => 'نقل إلى الفصل التالي',
    'books_sort_move_book_start' => 'نقل إلى بداية الكتاب',
    'books_sort_move_book_end' => 'نقل إلى نهاية الكتاب',
    'books_sort_move_before_chapter' => 'نقل إلى الفصل السابق',
    'books_sort_move_after_chapter' => 'نقل إلى الفصل التالي',
    'books_copy' => 'نسخة الكتاب',
    'books_copy_success' => 'تم نسخ الكتاب بنجاح',

    // Chapters
    'chapter' => 'فصل',
    'chapters' => 'فصول',
    'x_chapters' => ':count فصل|:count فصول',
    'chapters_popular' => 'فصول رائجة',
    'chapters_new' => 'فصل جديد',
    'chapters_create' => 'إنشاء فصل جديد',
    'chapters_delete' => 'حذف الفصل',
    'chapters_delete_named' => 'حذف فصل :chapterName',
    'chapters_delete_explain' => 'سيؤدي هذا إلى حذف الفصل الذي يحمل الاسم \':chapterName\'. كما سيتم حذف جميع الصفحات الموجودة داخل هذا الفصل.',
    'chapters_delete_confirm' => 'تأكيد حذف الفصل؟',
    'chapters_edit' => 'تعديل الفصل',
    'chapters_edit_named' => 'تعديل فصل :chapterName',
    'chapters_save' => 'حفظ الفصل',
    'chapters_move' => 'نقل الفصل',
    'chapters_move_named' => 'نقل فصل :chapterName',
    'chapters_copy' => 'نسخ الفصل',
    'chapters_copy_success' => 'تم نسخ الفصل بنجاح',
    'chapters_permissions' => 'أذونات الفصل',
    'chapters_empty' => 'لا توجد أي صفحات في هذا الفصل حالياً',
    'chapters_permissions_active' => 'أذونات الفصل مفعلة',
    'chapters_permissions_success' => 'تم تحديث أذونات الفصل',
    'chapters_search_this' => 'البحث في هذا الفصل',
    'chapter_sort_book' => 'فرز الكتاب',

    // Pages
    'page' => 'صفحة',
    'pages' => 'صفحات',
    'x_pages' => ':count صفحة|:count صفحات',
    'pages_popular' => 'صفحات رائجة',
    'pages_new' => 'صفحة جديدة',
    'pages_attachments' => 'مرفقات',
    'pages_navigation' => 'تصفح الصفحة',
    'pages_delete' => 'حذف الصفحة',
    'pages_delete_named' => 'حذف صفحة :pageName',
    'pages_delete_draft_named' => 'حذف مسودة :pageName',
    'pages_delete_draft' => 'حذف المسودة',
    'pages_delete_success' => 'تم حذف الصفحة',
    'pages_delete_draft_success' => 'تم حذف المسودة',
    'pages_delete_warning_template' => 'هذه الصفحة قيد الاستخدام كقالب افتراضي لصفحات الكتب أو الفصول. لن يكون لهذه الكتب أو الفصول قالب افتراضي بعد حذفها.',
    'pages_delete_confirm' => 'تأكيد حذف الصفحة؟',
    'pages_delete_draft_confirm' => 'تأكيد حذف المسودة؟',
    'pages_editing_named' => ':pageName قيد التعديل',
    'pages_edit_draft_options' => 'خيارات المسودة',
    'pages_edit_save_draft' => 'حفظ المسودة',
    'pages_edit_draft' => 'تعديل مسودة الصفحة',
    'pages_editing_draft' => 'المسودة قيد التعديل',
    'pages_editing_page' => 'الصفحة قيد التعديل',
    'pages_edit_draft_save_at' => 'تم خفظ المسودة في ',
    'pages_edit_delete_draft' => 'حذف المسودة',
    'pages_edit_delete_draft_confirm' => 'متيقِّن من رغبتك في حذف تغييرات صفحة المُسَوَّدَة؟ ستُفقد جميع تغييراتك، منذ آخر حفظ كامل، وسيتم تحديث المحرر بأحدث حالة حفظ للصفحة (غير مسودة).',
    'pages_edit_discard_draft' => 'التخلص من المسودة',
    'pages_edit_switch_to_markdown' => 'التبديل إلى محرر ماركداون -Markdown-',
    'pages_edit_switch_to_markdown_clean' => '(محتوى نظيف)',
    'pages_edit_switch_to_markdown_stable' => '(محتوى مستقر)',
    'pages_edit_switch_to_wysiwyg' => 'التبديل إلى محرر ما تراه هو ما تحصل عليه -WYSIWYG-',
    'pages_edit_switch_to_new_wysiwyg' => 'التبديل إلى محرر ما تراه هو ما تحصل عليه الجديد -new WYSIWYG-',
    'pages_edit_switch_to_new_wysiwyg_desc' => '(في الاختبار التجريبي)',
    'pages_edit_set_changelog' => 'تثبيت سجل التعديل',
    'pages_edit_enter_changelog_desc' => 'ضع وصف مختصر للتعديلات التي تمت',
    'pages_edit_enter_changelog' => 'أدخل سجل التعديل',
    'pages_editor_switch_title' => 'تبديل المحرر',
    'pages_editor_switch_are_you_sure' => 'متيقِّن أنك تريد تغيير المحرر لهذه الصفحة؟',
    'pages_editor_switch_consider_following' => 'عند تغيير المحررين، ضع في اعتبارك ما يلي:',
    'pages_editor_switch_consideration_a' => 'بمجرد الحفظ، سيتم استخدام خِيار المحرر الجديد بواسطة أي محررين مستقبليين، بما في ذلك أولئك الذين قد لا يتمكنون من تغيير نوع المحرر بأنفسهم.',
    'pages_editor_switch_consideration_b' => 'من الممكن أن يؤدي هذا إلى فقدان التفاصيل والنحو في ظروف معينة.',
    'pages_editor_switch_consideration_c' => 'لن تستمر تغييرات العلامة أو سجل التغييرات، التي تم إجراؤها منذ الحفظ الأخير، عبر هذا التغيير.',
    'pages_save' => 'حفظ الصفحة',
    'pages_title' => 'عنوان الصفحة',
    'pages_name' => 'اسم الصفحة',
    'pages_md_editor' => 'المحرر',
    'pages_md_preview' => 'معاينة',
    'pages_md_insert_image' => 'إدخال صورة',
    'pages_md_insert_link' => 'إدراج ارتباط الكيان',
    'pages_md_insert_drawing' => 'إدخال رسمة',
    'pages_md_show_preview' => 'عرض المعاينة',
    'pages_md_sync_scroll' => 'مزامنة معاينة التمرير',
    'pages_md_plain_editor' => 'محرر النصوص العادي',
    'pages_drawing_unsaved' => 'تم العثور على رسم غير محفوظ',
    'pages_drawing_unsaved_confirm' => 'تم العثور على بيانات رسم غير محفوظة من محاولة حفظ رسم سابقة فاشلة. هل ترغب في استعادة هذا الرسم غير المحفوظ ومواصلة تحريره؟',
    'pages_not_in_chapter' => 'صفحة ليست في فصل',
    'pages_move' => 'نقل الصفحة',
    'pages_copy' => 'نسخ الصفحة',
    'pages_copy_desination' => 'نسخ مكان الوصول',
    'pages_copy_success' => 'تم نسخ الصفحة بنجاح',
    'pages_permissions' => 'أذونات الصفحة',
    'pages_permissions_success' => 'تم تحديث أذونات الصفحة',
    'pages_revision' => 'مراجعة',
    'pages_revisions' => 'مراجعات الصفحة',
    'pages_revisions_desc' => 'تجد أدناه جميع الإصدارات السابقة لهذه الصفحة. يمكنك الاطلاع عليها ومقارنتها واستعادة الإصدارات القديمة إذا سمحت الصلاحيات بذلك. قد لا يظهر تاريخ الصفحة بالكامل هنا، إذ قد تُحذف الإصدارات القديمة تلقائيًا، وذلك حسب إعدادات النظام.',
    'pages_revisions_named' => 'مراجعات صفحة :pageName',
    'pages_revision_named' => 'مراجعة صفحة :pageName',
    'pages_revision_restored_from' => 'تم الاستعادة من #:id; :summary',
    'pages_revisions_created_by' => 'أنشئ بواسطة',
    'pages_revisions_date' => 'تاريخ المراجعة',
    'pages_revisions_number' => '#',
    'pages_revisions_sort_number' => 'رَقْم المراجعة',
    'pages_revisions_numbered' => 'مراجعة #:id',
    'pages_revisions_numbered_changes' => 'مراجعة #: رقم تعريفي التغييرات',
    'pages_revisions_editor' => 'نوع المحرر',
    'pages_revisions_changelog' => 'سجل التعديل',
    'pages_revisions_changes' => 'التعديلات',
    'pages_revisions_current' => 'النسخة الحالية',
    'pages_revisions_preview' => 'معاينة',
    'pages_revisions_restore' => 'استرجاع',
    'pages_revisions_none' => 'لا توجد مراجعات لهذه الصفحة',
    'pages_copy_link' => 'نسخ الرابط',
    'pages_edit_content_link' => 'انتقل إلى القسم في المحرر',
    'pages_pointer_enter_mode' => 'أدخل وضع اختيار القسم',
    'pages_pointer_label' => 'خيارات قسم الصفحة',
    'pages_pointer_permalink' => 'رابط دائم لقسم الصفحة',
    'pages_pointer_include_tag' => 'قسم الصفحة يتضمن العلامة',
    'pages_pointer_toggle_link' => 'وضع الرابط الدائم، اضغط لإظهار علامة التضمين',
    'pages_pointer_toggle_include' => 'تضمين وضع العلامة، اضغط لإظهار الرابط الدائم',
    'pages_permissions_active' => 'أذونات الصفحة مفعلة',
    'pages_initial_revision' => 'نشر مبدئي',
    'pages_references_update_revision' => 'التحديث التلقائي للنظام للروابط الداخلية',
    'pages_initial_name' => 'صفحة جديدة',
    'pages_editing_draft_notification' => 'جارٍ تعديل مسودة لم يتم حفظها من :timeDiff.',
    'pages_draft_edited_notification' => 'تم تحديث هذه الصفحة منذ ذلك الوقت. من الأفضل التخلص من هذه المسودة.',
    'pages_draft_page_changed_since_creation' => 'تم تحديث هذه الصفحة منذ إنشاء هذه المُسَوَّدَة. يُنصح بتجاهل هذه المُسَوَّدَة أو الحرص على عدم استبدال أي تغييرات في الصفحة.',
    'pages_draft_edit_active' => [
        'start_a' => ':count من المستخدمين بدأوا بتعديل هذه الصفحة',
        'start_b' => ':userName بدأ بتعديل هذه الصفحة',
        'time_a' => 'منذ أن تم تحديث هذه الصفحة',
        'time_b' => 'في آخر :minCount دقيقة/دقائق',
        'message' => 'وقت البدء: احرص على عدم الكتابة فوق تحديثات بعضنا البعض!',
    ],
    'pages_draft_discarded' => 'تم رفض المُسَوَّدَة! تم تحديث المحرر بمحتوى الصفحة الحالي.',
    'pages_draft_deleted' => 'تم حذف المُسَوَّدَة! تم تحديث المحرر بمحتوى الصفحة الحالي.',
    'pages_specific' => 'صفحة محددة',
    'pages_is_template' => 'قالب الصفحة',

    // Editor Sidebar
    'toggle_sidebar' => 'تبديل الشريط الجانبي',
    'page_tags' => 'وسوم الصفحة',
    'chapter_tags' => 'وسوم الفصل',
    'book_tags' => 'وسوم الكتاب',
    'shelf_tags' => 'علامات الرف',
    'tag' => 'وسم',
    'tags' =>  'وسوم',
    'tags_index_desc' => 'يمكن تطبيق الوسوم على المحتوى داخل النظام لتطبيق تصنيف مرن. يمكن أن تحتوي الوسوم على مفتاح وقيمة، مع العلم أن القيمة اختيارية. بعد تطبيقها، يمكن الاستعلام عن المحتوى باستخدام اسم الوسم وقيمته.',
    'tag_name' =>  'اسم العلامة',
    'tag_value' => 'قيمة الوسم (اختياري)',
    'tags_explain' => "إضافة الوسوم تساعد بترتيب وتقسيم المحتوى. \n من الممكن وضع قيمة لكل وسم لترتيب أفضل وأدق.",
    'tags_add' => 'إضافة وسم آخر',
    'tags_remove' => 'إزالة هذه العلامة',
    'tags_usages' => 'إجمالي استخدامات العلامة',
    'tags_assigned_pages' => 'مُخصصة للصفحات',
    'tags_assigned_chapters' => 'مُخصصة للفصول',
    'tags_assigned_books' => 'مُخصص للكتب',
    'tags_assigned_shelves' => 'مُخصصة للأرفف',
    'tags_x_unique_values' => 'قيم الفريدة :count',
    'tags_all_values' => 'جميع القيم',
    'tags_view_tags' => 'عرض العلامات',
    'tags_view_existing_tags' => 'عرض العلامات الموجودة',
    'tags_list_empty_hint' => 'يمكن تعيين العلامات بواسطة الشريط الجانبي لمحرر الصفحة أو خلال تحرير تفاصيل الكتاب أو الفصل أو الرف.',
    'attachments' => 'المرفقات',
    'attachments_explain' => 'ارفع بعض الملفات أو أرفق بعض الروابط لعرضها بصفحتك. ستكون الملفات والروابط معروضة في الشريط الجانبي للصفحة.',
    'attachments_explain_instant_save' => 'سيتم حفظ التغييرات هنا آنيا.',
    'attachments_upload' => 'رفع ملف',
    'attachments_link' => 'إرفاق رابط',
    'attachments_upload_drop' => 'وبدلاً من ذلك، يمكنك سحب المِلَفّ وإفلاته هنا لتحميله كمرفق.',
    'attachments_set_link' => 'تحديد الرابط',
    'attachments_delete' => 'هل أنت متأكد من أنك تريد حذف هذا المرفق؟',
    'attachments_dropzone' => 'قم بإسقاط الملفات هنا للتحميل',
    'attachments_no_files' => 'لم تُرفع أي ملفات',
    'attachments_explain_link' => 'بالإمكان إرفاق رابط في حال عدم تفضيل رفع ملف. قد يكون الرابط لصفحة أخرى أو لملف في أحد خدمات التخزين السحابي.',
    'attachments_link_name' => 'اسم الرابط',
    'attachment_link' => 'رابط المرفق',
    'attachments_link_url' => 'رابط الملف',
    'attachments_link_url_hint' => 'رابط الموقع أو الملف',
    'attach' => 'إرفاق',
    'attachments_insert_link' => 'إضافة رابط مرفق إلى الصفحة',
    'attachments_edit_file' => 'تعديل الملف',
    'attachments_edit_file_name' => 'اسم الملف',
    'attachments_edit_drop_upload' => 'أسقط الملفات أو اضغط هنا للرفع والاستبدال',
    'attachments_order_updated' => 'تم تحديث ترتيب المرفقات',
    'attachments_updated_success' => 'تم تحديث تفاصيل المرفق',
    'attachments_deleted' => 'تم حذف المرفق',
    'attachments_file_uploaded' => 'تم رفع الملف بنجاح',
    'attachments_file_updated' => 'تم تحديث الملف بنجاح',
    'attachments_link_attached' => 'تم إرفاق الرابط بالصفحة بنجاح',
    'templates' => 'القوالب',
    'templates_set_as_template' => 'هذه الصفحة عبارة عن قالب',
    'templates_explain_set_as_template' => 'يمكنك تعيين هذه الصفحة كقالب بحيث تستخدم محتوياتها عند إنشاء صفحات أخرى. سيتمكن المستخدمون الآخرون من استخدام هذا القالب إذا كان لديهم أذونات عرض لهذه الصفحة.',
    'templates_replace_content' => 'استبدال محتوى الصفحة',
    'templates_append_content' => 'تذييل محتوى الصفحة',
    'templates_prepend_content' => 'بادئة محتوى الصفحة',

    // Profile View
    'profile_user_for_x' => 'المستخدم لـ :time',
    'profile_created_content' => 'المحتوى المنشأ',
    'profile_not_created_pages' => 'لم يتم إنشاء أي صفحات بواسطة :userName',
    'profile_not_created_chapters' => 'لم يتم إنشاء أي فصول بواسطة :userName',
    'profile_not_created_books' => 'لم يتم إنشاء أي كتب بواسطة :userName',
    'profile_not_created_shelves' => 'لم يقم "اسم المستخدم"بإنشاء أي أرفف',

    // Comments
    'comment' => 'تعليق',
    'comments' => 'تعليقات',
    'comment_add' => 'إضافة تعليق',
    'comment_none' => 'لا توجد تعليقات لعرضها',
    'comment_placeholder' => 'ضع تعليقاً هنا',
    'comment_thread_count' => ':count تعليقات| :count تعليقات',
    'comment_archived_count' => ':count مؤرشف',
    'comment_archived_threads' => 'المواضيع المؤرشفة',
    'comment_save' => 'حفظ التعليق',
    'comment_new' => 'تعليق جديد',
    'comment_created' => 'تم التعليق :createDiff',
    'comment_updated' => 'تم التحديث :updateDiff بواسطة :username',
    'comment_updated_indicator' => 'تم التحديث',
    'comment_deleted_success' => 'تم حذف التعليق',
    'comment_created_success' => 'تمت إضافة التعليق',
    'comment_updated_success' => 'تم تحديث التعليق',
    'comment_archive_success' => 'تم أرشفة التعليق',
    'comment_unarchive_success' => 'تعليق غير مؤرشف',
    'comment_view' => 'عرض التعليق',
    'comment_jump_to_thread' => 'انتقل إلى الموضوع',
    'comment_delete_confirm' => 'تأكيد حذف التعليق؟',
    'comment_in_reply_to' => 'رداً على :commentId',
    'comment_reference' => 'المرجع',
    'comment_reference_outdated' => '(قديمة)',
    'comment_editor_explain' => 'هذه هي التعليقات المُضافة على هذه الصفحة. يُمكنك إضافة التعليقات وإدارتها عند عرض الصفحة المحفوظة.',

    // Revision
    'revision_delete_confirm' => 'هل أنت متأكد من أنك تريد حذف هذه المراجعة؟',
    'revision_restore_confirm' => 'هل أنت متأكد من أنك تريد استعادة هذه المراجعة؟ سيتم استبدال محتوى الصفحة الحالية.',
    'revision_cannot_delete_latest' => 'لايمكن حذف آخر مراجعة.',

    // Copy view
    'copy_consider' => 'يرجى مراعاة ما يلي عند نسخ المحتوى.',
    'copy_consider_permissions' => 'لن يتم نسخ إعدادات الصلاحيات المخصصة.',
    'copy_consider_owner' => 'سوف تصبح مالكًا لجميع المحتوى المنسوخ.',
    'copy_consider_images' => 'لن يتم تكرار ملفات صور الصفحة وستحتفظ الصور الأصلية بعلاقتها بالصفحة التي تم تحميلها إليها في الأصل.',
    'copy_consider_attachments' => 'لن يتم نسخ مرفقات الصفحة.',
    'copy_consider_access' => 'قد يؤدي تغيير الموقع أو المالك أو الصلاحيات إلى إمكانية وصول الأشخاص الذين لم يتمكنوا من الوصول إلى هذا المحتوى سابقًا.',

    // Conversions
    'convert_to_shelf' => 'تحويل إلى رف',
    'convert_to_shelf_contents_desc' => 'يمكنك تحويل هذا الكتاب إلى رف جديد بنفس المحتويات. سيتم تحويل الفصول الموجودة فيه إلى كتب جديدة. إذا احتوى هذا الكتاب على أي صفحات غير موجودة في أي فصل، فسيتم إعادة تسمية الكتاب وإضافة هذه الصفحات إليه، وسيصبح جزءًا من الرف الجديد.',
    'convert_to_shelf_permissions_desc' => 'سيتم نسخ أي صلاحيات مُحددة لهذا الكتاب إلى الرف الجديد وإلى جميع الكتب الفرعية الجديدة التي لم تُطبّق عليها صلاحيات خاصة بها. يُرجى العلم بأن الصلاحيات على الرفوف لا تنتقل تلقائيًا إلى المحتوى داخلها، كما هو الحال مع الكتب.',
    'convert_book' => 'تحويل الكتاب',
    'convert_book_confirm' => 'هل أنت متيقِّن أنك تريد تحويل هذا الكتاب؟',
    'convert_undo_warning' => 'لا يمكن التراجع عن هذا الأمر بسهولة.',
    'convert_to_book' => 'تحويله إلى كتاب',
    'convert_to_book_desc' => 'يمكنك تحويل هذا الفصل إلى كتاب جديد بنفس المحتوى. سيتم نسخ أي صلاحيات مُعيّنة لهذا الفصل إلى الكتاب الجديد، ولكن لن يتم نسخ أي صلاحيات موروثة من الكتاب الأصلي، مما قد يؤدي إلى تغيير في التحكم في الوصول.',
    'convert_chapter' => 'تحويل الفصل',
    'convert_chapter_confirm' => 'هل أنت متيقِّن أنك تريد تحويل هذا الفصل؟',

    // References
    'references' => 'مراجع',
    'references_none' => 'لا توجد مراجع متعقبة لهذا العنصر.',
    'references_to_desc' => 'تجد أدناه كل المحتوى المعروف في النظام المرتبط بهذا العنصر.',

    // Watch Options
    'watch' => 'شاهد',
    'watch_title_default' => 'التفضيلات الافتراضية',
    'watch_desc_default' => 'استعادة المشاهدة إلى تفضيلات الإشعارات الافتراضية فقط.',
    'watch_title_ignore' => 'تجاهل',
    'watch_desc_ignore' => 'تجاهل كافة الإشعارات، بما في ذلك تلك الواردة من تفضيلات مستوى المستخدم.',
    'watch_title_new' => 'صفحات جديدة',
    'watch_desc_new' => 'إعلام عند إنشاء أي صفحة جديدة ضمن هذا العنصر.',
    'watch_title_updates' => 'جميع تحديثات الصفحة',
    'watch_desc_updates' => 'إشعار بجميع الصفحات الجديدة والتغييرات في الصفحات.',
    'watch_desc_updates_page' => 'إشعار عند حدوث أي تغييرات في الصفحة.',
    'watch_title_comments' => 'جميع تحديثات الصفحة والتعليقات',
    'watch_desc_comments' => 'إشعار بجميع الصفحات الجديدة، وتغييرات الصفحات والتعليقات الجديدة.',
    'watch_desc_comments_page' => 'إشعار عند حدوث تغييرات في الصفحة أو تعليقات جديدة.',
    'watch_change_default' => 'تغيير تفضيلات الإشعارات الافتراضية',
    'watch_detail_ignore' => 'تجاهل الإشعارات',
    'watch_detail_new' => 'ترقب الصفحات الجديدة',
    'watch_detail_updates' => 'مشاهدة الصفحات الجديدة والتحديثات',
    'watch_detail_comments' => 'مشاهدة الصفحات الجديدة والتحديثات والتعليقات',
    'watch_detail_parent_book' => 'المشاهدة عبر الكتاب الرئيس',
    'watch_detail_parent_book_ignore' => 'التجاهل عبر الكتاب الرئيس',
    'watch_detail_parent_chapter' => 'المشاهدة عبر الفصل الرئيس',
    'watch_detail_parent_chapter_ignore' => 'التجاهل عبر الفصل الرئيس',
];
